/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import noppes.npcs.client.model.animation.EmotionConfig;
import noppes.npcs.client.model.animation.EmotionFrame;
import noppes.npcs.constants.EnumAnimationStages;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.util.ValueUtil;

public class EmotionHandler {
    private final EntityLivingBase entity;
    public final Map<Integer, Float[]> rotationAngles = new TreeMap<Integer, Float[]>();
    public EmotionConfig activeEmotion = null;
    public EmotionFrame preFrame = EmotionFrame.EMPTY.copy();
    public EmotionFrame currentFrame;
    public EmotionFrame nextFrame;
    public EnumAnimationStages stage = EnumAnimationStages.Waiting;
    public long startEmotionTime = 0L;
    public int baseEmotionId = -1;
    public int speedTicks;
    public int timeTicks;

    public EmotionHandler(EntityLivingBase main) {
        this.entity = main;
    }

    public EmotionConfig getEmotion() {
        return this.activeEmotion;
    }

    public void calculationEmotionData(float partialTicks) {
        if (this.stage == EnumAnimationStages.Waiting || this.activeEmotion == null) {
            return;
        }
        int ticks = Math.max(0, (int)(this.entity.field_70170_p.func_82737_E() - this.startEmotionTime));
        this.speedTicks = 0;
        switch (this.stage) {
            case Started: {
                this.currentFrame = this.preFrame;
                this.nextFrame = this.activeEmotion.frames.get(0);
                break;
            }
            case Looping: {
                this.currentFrame = this.activeEmotion.frames.get(this.activeEmotion.frames.size() - 1);
                int lastFrameId = this.activeEmotion.frames.size();
                int frameId = this.activeEmotion.repeatLast > 0 ? ValueUtil.correctInt(lastFrameId - this.activeEmotion.repeatLast, 0, lastFrameId - 1) : lastFrameId - 1;
                this.nextFrame = this.activeEmotion.frames.get(frameId);
                this.speedTicks = this.currentFrame.speed;
                break;
            }
            case Run: {
                int emotionFrame = this.activeEmotion.getEmotionFrameByTime(ticks);
                if (emotionFrame < 0) {
                    emotionFrame = 0;
                }
                this.currentFrame = this.activeEmotion.frames.getOrDefault(emotionFrame, this.activeEmotion.frames.get(0));
                this.nextFrame = this.activeEmotion.frames.get(Math.min(emotionFrame + 1, this.activeEmotion.frames.size() - 1));
                if (this.activeEmotion.editFrame >= 0) {
                    this.speedTicks = 1;
                    ticks = 1;
                } else {
                    this.speedTicks = this.currentFrame.speed;
                }
                if (!this.activeEmotion.endingFrameTicks.containsKey(emotionFrame - 1)) break;
                ticks -= this.activeEmotion.endingFrameTicks.get(emotionFrame - 1).intValue();
                break;
            }
            case Ending: {
                this.currentFrame = this.activeEmotion.frames.get(this.activeEmotion.frames.size() - 1);
                this.nextFrame = EmotionFrame.EMPTY;
                break;
            }
            default: {
                this.stopEmotion();
            }
        }
        this.timeTicks = ticks;
        for (int partId = 0; partId < 7; ++partId) {
            Float[] values = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
            for (int t = 0; t < 3; ++t) {
                for (int a = 0; a < 2; ++a) {
                    float value_1;
                    float value_0;
                    if (t == 2 && a == 1) continue;
                    block6 : switch (t) {
                        case 1: {
                            switch (partId) {
                                case 1: {
                                    value_0 = this.currentFrame.scaleEye[a + 2];
                                    value_1 = this.nextFrame.scaleEye[a + 2];
                                    break block6;
                                }
                                case 2: {
                                    value_0 = this.currentFrame.scalePupil[a];
                                    value_1 = this.nextFrame.scalePupil[a];
                                    break block6;
                                }
                                case 3: {
                                    value_0 = this.currentFrame.scalePupil[a + 2];
                                    value_1 = this.nextFrame.scalePupil[a + 2];
                                    break block6;
                                }
                                case 4: {
                                    value_0 = this.currentFrame.scaleBrow[a];
                                    value_1 = this.nextFrame.scaleBrow[a];
                                    break block6;
                                }
                                case 5: {
                                    value_0 = this.currentFrame.scaleBrow[a + 2];
                                    value_1 = this.nextFrame.scaleBrow[a + 2];
                                    break block6;
                                }
                                case 6: {
                                    value_0 = this.currentFrame.scaleMouth[a];
                                    value_1 = this.nextFrame.scaleMouth[a];
                                    break block6;
                                }
                            }
                            value_0 = this.currentFrame.scaleEye[a];
                            value_1 = this.nextFrame.scaleEye[a];
                            break;
                        }
                        case 2: {
                            switch (partId) {
                                case 1: {
                                    value_0 = this.currentFrame.rotEye[1];
                                    value_1 = this.nextFrame.rotEye[1];
                                    break block6;
                                }
                                case 2: {
                                    value_0 = this.currentFrame.rotPupil[0];
                                    value_1 = this.nextFrame.rotPupil[0];
                                    break block6;
                                }
                                case 3: {
                                    value_0 = this.currentFrame.rotPupil[1];
                                    value_1 = this.nextFrame.rotPupil[1];
                                    break block6;
                                }
                                case 4: {
                                    value_0 = this.currentFrame.rotBrow[0] - 0.5f;
                                    value_1 = this.nextFrame.rotBrow[0] - 0.5f;
                                    break block6;
                                }
                                case 5: {
                                    value_0 = this.currentFrame.rotBrow[1];
                                    value_1 = this.nextFrame.rotBrow[1];
                                    break block6;
                                }
                                case 6: {
                                    value_0 = this.currentFrame.rotMouth;
                                    value_1 = this.nextFrame.rotMouth;
                                    break block6;
                                }
                            }
                            value_0 = this.currentFrame.rotEye[0];
                            value_1 = this.nextFrame.rotEye[0];
                            break;
                        }
                        default: {
                            switch (partId) {
                                case 1: {
                                    value_0 = this.currentFrame.offsetEye[a + 2];
                                    value_1 = this.nextFrame.offsetEye[a + 2];
                                    break block6;
                                }
                                case 2: {
                                    value_0 = this.currentFrame.offsetPupil[a];
                                    value_1 = this.nextFrame.offsetPupil[a];
                                    break block6;
                                }
                                case 3: {
                                    value_0 = this.currentFrame.offsetPupil[a + 2];
                                    value_1 = this.nextFrame.offsetPupil[a + 2];
                                    break block6;
                                }
                                case 4: {
                                    value_0 = this.currentFrame.offsetBrow[a];
                                    value_1 = this.nextFrame.offsetBrow[a];
                                    break block6;
                                }
                                case 5: {
                                    value_0 = this.currentFrame.offsetBrow[a + 2];
                                    value_1 = this.nextFrame.offsetBrow[a + 2];
                                    break block6;
                                }
                                case 6: {
                                    value_0 = this.currentFrame.offsetMouth[a];
                                    value_1 = this.nextFrame.offsetMouth[a];
                                    break block6;
                                }
                            }
                            value_0 = this.currentFrame.offsetEye[a];
                            value_1 = this.nextFrame.offsetEye[a];
                        }
                    }
                    values[t * 2 + a] = Float.valueOf(this.calcValue(value_0, value_1, this.speedTicks, ticks, this.currentFrame.isSmooth(), partialTicks));
                }
            }
            this.rotationAngles.put(partId, values);
        }
        this.preFrame.resetFrom(this.rotationAngles, this.currentFrame);
    }

    private float calcValue(float value_0, float value_1, float speed, float ticks, boolean isSmooth, float partialTicks) {
        if (speed <= 0.0f || ticks < 0.0f) {
            return value_0;
        }
        float progress = Math.min((ticks + partialTicks) / speed, 1.0f);
        if (progress >= 1.0f) {
            return value_1;
        }
        if (isSmooth) {
            progress = -0.5f * MathHelper.func_76134_b((float)(progress * (float)Math.PI)) + 0.5f;
        }
        return value_0 + (value_1 - value_0) * progress;
    }

    public EmotionConfig tryRunEmotion(EmotionConfig emotion) {
        if (emotion == null) {
            return null;
        }
        this.activeEmotion = emotion;
        this.startEmotionTime = this.entity.field_70170_p.func_82737_E();
        this.stage = EnumAnimationStages.Started;
        return this.activeEmotion;
    }

    public void tryRunEmotion(int emotionId) {
        this.tryRunEmotion(AnimationController.getInstance().emotions.get(emotionId));
    }

    public void stopEmotion() {
        this.currentFrame = EmotionFrame.EMPTY;
        this.rotationAngles.clear();
        this.startEmotionTime = 0L;
        this.currentFrame = null;
        this.nextFrame = null;
        this.timeTicks = -1;
        this.speedTicks = -1;
    }

    public void load(NBTTagCompound compound) {
        this.baseEmotionId = compound.func_74762_e("BaseEmotionId");
        if (!AnimationController.getInstance().emotions.containsKey(this.baseEmotionId)) {
            this.baseEmotionId = -1;
        }
    }

    public void save(NBTTagCompound compound) {
        compound.func_74768_a("BaseEmotionId", this.baseEmotionId);
    }

    public boolean isAnimated() {
        return (this.activeEmotion != null && this.stage != EnumAnimationStages.Waiting || AnimationController.getInstance().emotions.containsKey(this.baseEmotionId)) && this.entity.func_110143_aJ() > 0.0f;
    }

    public void updateTime() {
        if (this.activeEmotion == null) {
            this.currentFrame = null;
            this.nextFrame = null;
            this.stage = EnumAnimationStages.Waiting;
            this.startEmotionTime = 0L;
            this.timeTicks = -1;
            return;
        }
        if (!AnimationController.getInstance().emotions.containsKey(this.activeEmotion.id) && this.stage != EnumAnimationStages.Ending && this.stage != EnumAnimationStages.Waiting) {
            this.stage = EnumAnimationStages.Ending;
            this.startEmotionTime = this.entity.field_70170_p.func_82737_E() + 1L;
            return;
        }
        int ticks = Math.max(0, (int)(this.entity.field_70170_p.func_82737_E() - this.startEmotionTime));
        if (this.activeEmotion.editFrame >= 0) {
            this.stage = EnumAnimationStages.Run;
            if (ticks >= this.activeEmotion.totalTicks) {
                this.startEmotionTime = this.entity.field_70170_p.func_82737_E() + 1L;
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Started) {
            int speed = 10;
            if (ticks >= speed) {
                this.startEmotionTime += (long)(speed + 1);
                this.stage = EnumAnimationStages.Run;
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Looping) {
            int speed = this.activeEmotion.frames.get((Object)Integer.valueOf((int)(this.activeEmotion.frames.size() - 1))).speed;
            if (ticks >= speed) {
                int lastFrameId = this.activeEmotion.frames.size();
                int frameId = this.activeEmotion.repeatLast > 0 ? ValueUtil.correctInt(lastFrameId - this.activeEmotion.repeatLast, 0, lastFrameId - 1) : lastFrameId - 1;
                this.startEmotionTime = frameId == 0 ? this.entity.field_70170_p.func_82737_E() + 1L : this.entity.field_70170_p.func_82737_E() + (long)this.activeEmotion.endingFrameTicks.get(frameId - 1).intValue() + 1L;
                if (frameId != lastFrameId - 1) {
                    this.stage = EnumAnimationStages.Run;
                }
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Run) {
            if (ticks >= this.activeEmotion.totalTicks) {
                this.startEmotionTime = this.entity.field_70170_p.func_82737_E() + 1L;
                this.stage = EnumAnimationStages.Looping;
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Ending) {
            int speed = 10;
            if (ticks >= speed) {
                this.startEmotionTime = 0L;
                this.stage = EnumAnimationStages.Waiting;
            }
            return;
        }
        if (this.stage == EnumAnimationStages.Waiting) {
            this.stopEmotion();
        }
    }

    public void setRotationAngles(float ignoredLimbSwing, float ignoredLimbSwingAmount, float ignoredAgeInTicks, float ignoredNetHeadYaw, float ignoredHeadPitch, float ignoredScaleFactor, float partialTicks) {
        if (this.activeEmotion == null && !AnimationController.getInstance().emotions.containsKey(this.baseEmotionId)) {
            return;
        }
        if (this.activeEmotion == null) {
            this.tryRunEmotion(this.baseEmotionId);
        } else {
            this.calculationEmotionData(partialTicks);
        }
    }
}

